// Selection +.js
//

// v.20090618 fix seletion function.
// v.20100130 fix bug for 5.2
// v.20120927 add border edge option. undo support.

/*
Vec3D.prototype.dot = function( p) {
	return this.x * p.x + this.y * p.y + this.z * p.z;
}
Vec3D.prototype.cross = function( p) {
	return new Vec3D(this.y * p.z - this.z * p.y, this.x * p.z - this.z * p.x,this.x * p.y - this.y * p.x);
}
Vec3D.prototype.length = function() {
	return  Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
}
Vec3D.prototype.normalize = function() {
	var l = this.norm();
	return (l == 0 ) ? new Vec3D() : this.multiply(1/l);
}
Vec3D.prototype.toString = function() {
	return "(" + this.x.toFixed(4) + ", " + this.y.toFixed(4) + ", " + this.z.toFixed(4) + ")";
}
*/
//
function Edge(p1, p2, v1, v2) {
	this.p1 = p1;
	this.p2 = p2;
	//
	this.v1 = v1;
	this.v2 = v2;
}

Edge.prototype.toString = function() {
	return '(e) p1:'+this.p1+' p2:'+this.p2+' v1:'+this.v1+' v2:'+this.v2+'/';
}

//
Array.prototype.pushEdge = function(p, v1, v2) {
	var isPushed = false;
	var len = this.length;
	for (var i = 0;i < len;i++) {
		if ( (this[i].v1 == v1 && this[i].v2 == v2) || (this[i].v2 == v1 && this[i].v1 == v2) ) {
			isPushed = true;
			if (this[i].p2 == null) {
				this[i].p2 = p;
			}
		}
	}
	if (isPushed == false) {
		this.push( new Edge(p, null, v1, v2) );
	}
}

//
var vec3_toString = function(vec) {
  return "("+vec.x.toFixed(3)+", "+vec.y.toFixed(3)+", "+vec.z.toFixed(3)+")";
}
//
function buildUI(tool) {
  /*
  tool.addParameterSeparator("□ Select 1 Over N");
  tool.addParameterButton("select poly over N", "select", "selectOverNPolygons");
   */
   
	tool.addParameterSeparator("□ Normal Polygons");
	tool.addParameterFloat("tolerance angle", 0.5, 0, 180, false, false);
	tool.addParameterBool("side-by-side", 0, 0, 1, false, false);
	tool.addParameterButton("same normal", "select", "selectSameNormal");
	
  tool.addParameterSeparator("□ Select Non Planar");
  tool.addParameterFloat("planer accuracy", 0.005, 0, 0.1, false, false);
  tool.addParameterButton("select non planar", "select", "selectNonPlanar");
  
  tool.addParameterSeparator("/ Select 1 Over N");
  tool.addParameterInt("over N", 1, 1, 10000, false, false);
  tool.addParameterButton("expand edge over N", "expand", "expandOverNEdges");
  
	tool.addParameterSeparator("/ Open Edges");
	tool.addParameterButton("open edges", "select", "selectOpenEdges");
	
	tool.addParameterSeparator("/ Cover Edges");
	tool.addParameterButton("cover edges", "select", "selectCoverEdges");
	
	/*
  tool.addParameterSeparator("/ Manifold Edges");
  tool.addParameterButton("manifold edges", "select", "selectManifoldEdges");
   */
  
  tool.addParameterSeparator("□→/ Convert to Border Edge");
  tool.addParameterBool("overwrite selection", 1, 0, 1, false, false);
  tool.addParameterButton("convert border", "convert", "convertToBorderEdge");

}

function selectOverNPolygons(tool) {

}

function selectSameNormal(tool) {
	var obj = tool.document().selectedObject();
	var tol = tool.getParameter("tolerance angle");
	
	if (! obj || obj.family() != NGONFAMILY) {
		return;
	}
	
	if (tool.document().editMode() != POLY_MODE) {
		OS.beep();
		return;
	}
	var c_tol = 1 - (tol*Math.PI/180);
	
	var core = obj.core();
	var count = core.polygonCount();
	var sel_idx = null;
	var sel_norm = null;
	var sels = [];
	var p_sels = [];
	var i, j, k;
	
  obj.recordGeometryForUndo();

	for (i = count - 1; i >= 0; i--) {
		if (core.polygonSelection(i)) {
			var normal = core.normal(i);
			p_sels.push(i);
			
			for (j = count - 1;j >= 0;j--) {
				if (i != j) {
					var b_normal = core.normal(j);
					
                    var b_dot = normal.dot(b_normal);
                    b_dot = (b_dot.dot)? b_dot.x : b_dot;
					if (b_dot >= c_tol) {
						sels.push(j);
					}
				}
			}
		}
	}
	
	if (tool.getParameter("side-by-side")) {
		var v1, v2;
		var vecs = [];
		var p_count = p_sels.length;
		var pi, size = 0;
		for (i = 0; i < p_count;i++) {
			pi = p_sels[i];
			size = core.polygonSize(pi);
			for (j = 0;j < size;j++) {
				v1 = core.vertexIndex(pi, j);
				v2 = core.vertexIndex(pi, (j == size - 1)? 0 : j+1);
				vecs.push( [v1, v2] );
			}
		}
		var sel;
		var vlen = vecs.length;
		var len = sels.length;
		for (i = 0;i < len;i++) {
			sel = false
			pi = sels[i];
			size = core.polygonSize( pi );
			if ( core.polygonSelection(pi) ) {
				;
			} else {
				for (j = 0;j < size;j++) {
					v1 = core.vertexIndex(pi, j);
					v2 = core.vertexIndex(pi, (j == size - 1)? 0 : j+1);
					
					for (k = 0;k < vlen;k++) {
						if ( (vecs[k][0] == v1 && vecs[k][1] == v2) || 
								(vecs[k][1] == v1 && vecs[k][0] == v2) ) {
							sel = true;
						}
					}
				}
				if (sel) {
					core.setPolygonSelection(pi, true);
				}
			}
		}
	} else {
		var len = sels.length;
		for (i = 0;i < len;i++) {
			core.setPolygonSelection(sels[i], true);
		}
	}
	obj.update();
}

function selectNonPlanar(tool) {
  var obj = tool.document().selectedObject();
  
  if (! obj || obj.family() != NGONFAMILY) {
  	return;
  }
  
  if (tool.document().editMode() != POLY_MODE) {
  	OS.beep();
  	return;
  }
  
  obj.recordGeometryForUndo();
  
  var core = obj.core();
  var accuracy = tool.getParameter("planer accuracy");
  
  var polygonCount = core.polygonCount();
  for (var i = 0;i < polygonCount;i++) {
    
    var size = core.polygonSize(i);
    var info, a, b, c, ab, ac, p, ap;
    
    if (size < 4) continue;
    
    a = core.vertex( core.vertexIndex( i, 0 ) );
    b = core.vertex( core.vertexIndex( i, 1 ) );
    c = core.vertex( core.vertexIndex( i, 2 ) );
    
    ab = b.sub( a );
    ac = c.sub( a );
    
    var baseNormal = ac.cross( ab );
    if (baseNormal.norm() > 1) baseNormal = baseNormal.multiply( 1 / baseNormal.norm() );
    var result = false;
    
    for (var j = 3;j < size;j++) {
      p = core.vertex( core.vertexIndex( i, j ) );
      
      ap = p.sub( a );
      var pr = baseNormal.dot( ap );
      pr = (pr.dot)? pr.x : pr;
      
      if (Math.abs( pr ) > accuracy) {
        result = true;
      }
      
      core.setPolygonSelection( i, result );
    }
  }
  
  obj.update();
}

function selectOverNEdges(tool) {
    var obj = tool.document().selectedObject();

    if (! obj || obj.family() != NGONFAMILY) {
        OS.beep();
        return;
    }

    if (tool.document().editMode() != EDGE_MODE) {
        OS.beep();
        return;
    }

    var sels = [];
    var edges = [];
    var core = obj.core();
    var count = core.polygonCount();
    var size, i, j, k;

    for (i = 0;i < count;i++) {
        size = core.polygonSize(i);
        for (j = 0;j < size;j++) {
            v1 = core.vertexIndex(i, j);
            v2 = core.vertexIndex(i, (j == size-1)? 0 : j+1 );
            if (core.edgeSelection(i, j, SELECT)) {
                sels.pushEdge(i, v1, v2);
            } else {
                edges.pushEdge(i, v1, v2);
            }
        }
    }
    //
    var v_list = [];
    var len = sels.length;
}

function selectOpenEdges(tool) {
	var obj = tool.document().selectedObject();
	
	if (! obj || obj.family() != NGONFAMILY) {
		OS.beep();
		return;
	}
	
	if (tool.document().editMode() != EDGE_MODE) {
		OS.beep();
		return;
	}
	
	var sels = [];
	var edges = [];
	var core = obj.core();
	var count = core.polygonCount();
	var size, i, j, k;
	
	for (i = 0;i < count;i++) {
		size = core.polygonSize(i);
		for (j = 0;j < size;j++) {
			v1 = core.vertexIndex(i, j);
			v2 = core.vertexIndex(i, (j == size-1)? 0 : j+1 );
			if (core.edgeSelection(i, j, SELECT)) {
				sels.pushEdge(i, v1, v2);
			} else {
				edges.pushEdge(i, v1, v2);
			}
		}
	}
	//
	var v_list = [];
	var len = sels.length;
	for (i = 0;i < len;i++) {
		var edge = sels[i];
		var v1_ins = true;
		var v2_ins = true;
		var vlen = v_list.length;
		for (j = 0;j < vlen;j++) {
			if (v_list[j][0] == edge.v1) {
				v1_ins = false;
				v_list[j][1] += 1;
			}
			if (v_list[j][0] == edge.v2) {
				v2_ins = false;
				v_list[j][1] += 1;
			}
		}
		if (v1_ins) v_list.push([edge.v1, 1]);
		if (v2_ins) v_list.push([edge.v2, 1]);
	}
	
	edges_new = [];
	for (i = edges.length - 1;i >= 0;i--) { // only open edge.
		if (edges[i].p2 == null) {
			edges_new.push( edges[i] );
		}
	}
	
  obj.recordGeometryForUndo();

	var loop_count = 0;
	var loop = true;
	while (loop && edges_new.length > 0) {
		var elen = edges_new.length;
		for (i = 0;i < elen;i++) {
			var vlen = v_list.length;
			var edge = edges_new[i];
			var insert_edge = false;
			for (j = 0;j < vlen;j++) {
				var insert_edge = false;
				if (v_list[j][1] == 1) {
					if (v_list[j][0] == edge.v1) {
						size = core.polygonSize(edge.p1);
						for (k = 0;k < size;k++) {
							if (edge.v1 == core.vertexIndex(edge.p1, k)) {
								core.setEdgeSelection(edge.p1, k, SELECT, true);
								core.setEdgeSelection(edge.p1, k, UVEDGE, true);
								v_list[j][1] += 1;
								insert_edge = edge.v2;
								break;
							}
						}
					} else if (v_list[j][0] == edge.v2) {
						size = core.polygonSize(edge.p1);
						for (k = 0;k < size;k++) {
							if (edge.v2 == core.vertexIndex(edge.p1, k)) {
								if (k == 0) {
									core.setEdgeSelection(edge.p1, size - 1, SELECT, true);
									core.setEdgeSelection(edge.p1, size - 1, UVEDGE, true);
								} else {
									core.setEdgeSelection(edge.p1, k-1, SELECT, true);
									core.setEdgeSelection(edge.p1, k-1, UVEDGE, true);
								}
								v_list[j][1] += 1;
								insert_edge = edge.v1;
								break;
							}
						}
					}
				}
				if (insert_edge != false) {
					var insert = true;
					for (k = 0;k < vlen;k++) {
						if (v_list[k][0] == insert_edge) {
							insert = false;
							v_list[k][1] += 1;
						}
					}
					if (insert) {
						v_list.push( [ insert_edge, 1 ] );
					}
				}
			}
		}
		// check
		loop = false;
		for (i = 0;i < v_list.length;i++) {
			if (v_list[i][1] == 1) {
				loop = true;
			}
		}
		if (loop_count++ > 1000) loop = false;
		//
		
	}
	obj.update();
}

function selectCoverEdges(tool) {
	var obj = tool.document().selectedObject();
	
	if (! obj || obj.family() != NGONFAMILY) {
		return;
	}
	
	if (tool.document().editMode() != EDGE_MODE) {
		OS.beep();
		return;
	}
	
	var core = obj.core();
	var count = core.polygonCount();
	var size = 0;
	var sels = [];
	var insert = false;
	var len = 0;
	var i,j,k;
	
  obj.recordGeometryForUndo();

	for (i = 0; i < count; i++) {
		size = core.polygonSize(i);
		for (j = 0;j < size;j++) {
			if (core.edgeSelection(i, j, SELECT)) {
				insert = true;
				len = sels.length;
				for (k = 0;k < len;k++) {
					if (sels[k][0] == i) {
						insert = false;
						sels[k][1] += 1;
					}
				}
				if (insert) {
					sels.push( [i, 1] );
				}
			}
		}
	}
	
	var vecs = [];
	var v1, v2, pi;
	len = sels.length;
	for (i = 0; i < len;i++) {
		if (sels[i][1] > 1) {
			pi = sels[i][0];
			size = core.polygonSize( pi );
			
			for (j = 0;j < size;j++) {
				core.setEdgeSelection( sels[i][0], j, SELECT, true );
				core.setEdgeSelection( sels[i][0], j, UVEDGE, true );
				
				v1 = core.vertexIndex( pi, j  );
				v2 = core.vertexIndex( pi, (j == size-1)? 0 : j+1 );
				vecs.push( [v1, v2] );
			}
		}
	}
	
	var v_len = vecs.length;
	len = core.polygonCount();
	for (i = 0;i < len;i++) {
		size = core.polygonSize( i );
		for (j = 0;j < size;j++) {
			v1 = core.vertexIndex(i,j);
			v2 = core.vertexIndex(i, (j == size-1)? 0 : j+1 );
			for (k = 0;k < v_len;k++) {
				if (( v1 == vecs[k][0] && v2 == vecs[k][1] )) {
					core.setEdgeSelection(i, j, SELECT, true);
					core.setEdgeSelection(i, j, UVEDGE, true);
				} else if ((v1 == vecs[k][1] && v2 == vecs[k][0])) {
					core.setEdgeSelection(i, j, SELECT, true);
					core.setEdgeSelection(i, j, UVEDGE, true);
				}
			}
		}
	}
	
	obj.update();
}

function convertToBorderEdge( tool ) {
  var doc = tool.document();
  var obj = doc.selectedObject();
  
  if (doc.editMode() != POLY_MODE) {
    OS.beep(); return;
  }
  
  if (obj && obj.type() == POLYGONOBJ) {
    var core = obj.core();
    var i, j;
    
    var overwrite = tool.getParameter("overwrite selection");
    
    obj.recordGeometryForUndo();
    
    var corners = new Array();
    var polygonCount = core.polygonCount();
    
    for (i = 0;i < polygonCount;i++) {
      var polygonSize = core.polygonSize( i );
      for (j = 0;j < polygonSize;j++) {
        var c0 = j;
        var c1 = (j == polygonSize - 1)? 0 : j + 1;
        
        corners.pushUniqueCorner( 
              new Array( [ i, j ], [ core.vertexIndex( i, c0 ), core.vertexIndex( i, c1 ) ], core.polygonSelection( i ) )
                                );
        if (overwrite) {
          core.setEdgeSelection( i, j, SELECT, false );
          core.setEdgeSelection( i, j, UVEDGE, false );
        }
      }
    }
    
    var len = corners.length;
    for (i = 0;i < len;i++) {
      var corner = corners[i];
      if (corner[3][0] + corner[3][1] == 1) {
        core.setEdgeSelection( corner[0][0], corner[0][1], SELECT, true );
        if (corner[1].length > 1) core.setEdgeSelection( corner[1][0], corner[1][1], SELECT, true );
        
        if (corner[3][0] == 1) {
          core.setEdgeSelection( corner[0][0], corner[0][1], UVEDGE, true);
        }
        if (corner[3][1] == 1) {
          core.setEdgeSelection( corner[1][0], corner[1][1], UVEDGE, true);
        }
      }
    }
    
    obj.update();
  }
}

Array.prototype.toString = function() {
  var len = this.length;
  var str = '(';
  for (var i = 0;i < len;i++) {
    str += this[i];
    if (i < len -1) {
      str += ',';
    }
  }
  return str + ')';
}

Array.prototype.pushUniqueCorner = function( indices ) { // [ cornerInfo[], vertexIndices[], selCount ]
  indices[1].sort();
  var len = this.length;
  for (var i = 0;i < len;i++) {
    if (this[i][2][0] == indices[1][0] && this[i][2][1] == indices[1][1]) {
      this[i][1] = indices[0];
      if (indices[2]) {
        this[i][3][1] = 1;
      }
      return this;
    }
  }
  // cornerInfo1[], cornerInfo2[], vertexIndices[], selCount
  this.push( new Array( indices[0], [], indices[1], (indices[2])? [1, 0] : [0, 0] ) );
  return this;
}
